/*
  Base which spawns ball for Bombing Run game.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary 
*/

class UTBRBallBase extends UTGameObjective
	hidecategories(Objective,VoiceMessage,Announcements)
	placeable;

var UTBRBall TheBall;

var() StaticMeshComponent Mesh;

simulated function PostBeginPlay()
{
	Enable('Touch');

	Super(UTGameObjective).PostBeginPlay();

	if ( Role < ROLE_Authority )
		return;

	if ( UTBRGame(WorldInfo.Game) != None )
	{
		//note, important to spawn ball at the proper position using HomeBaseOffset, otherwise
		//ball could spawn inside the floor and not spawn at all
		TheBall = Spawn(class'UTBRBall',,, Location + (class'UTBRBall'.default.HomeBaseOffset >> Rotation));
		
		UTBRGame(WorldInfo.Game).RegisterBallHomeBase(self);		
		UTBRGame(WorldInfo.Game).RegisterBall(TheBall);
		
		TheBall.SendHome(none);	
	}
}

event actor GetBestViewTarget()
{
	return self;
}

simulated function String GetHumanReadableName()
{
	return "Ball Base";
}

//no voice proximity messages are played for a ball base (such as 'Enemy flag carrier near the blue base'), 
//nor are any voice message availaible for this in ut
simulated function int GetLocationMessageIndex(UTBot B, Pawn StatusPawn)
{
	return 0;
}

simulated function SoundNodeWave GetLocationSpeechFor(PlayerController PC, int LocationSpeechOffset, int MessageIndex)
{
	return None;
}

function ObjectiveChanged()
{
}

simulated event ReplicatedEvent(name VarName)
{
   Super.ReplicatedEvent(VarName);
}


simulated event bool IsActive()
{
	return true;
}

function UTCarriedObject GetFlag()
{
	return TheBall;
}

defaultproperties
{     	
   Name="Default__UTBRBallBase"
   ObjectArchetype=UTGameObjective'UTGame.Default__UTGameObjective'    
   CameraViewDistance=400.000000
   
   Begin Object Class=DynamicLightEnvironmentComponent Name=BaseLightEnvironment ObjName=BaseLightEnvironment Archetype=DynamicLightEnvironmentComponent'Engine.Default__DynamicLightEnvironmentComponent'
      bCastShadows=False
      bDynamic=False
      Name="BaseLightEnvironment"
      ObjectArchetype=DynamicLightEnvironmentComponent'Engine.Default__DynamicLightEnvironmentComponent'
   End Object

   DrawScale=0.4         
   
   Begin Object Class=StaticMeshComponent Name=StaticMeshComponent0 ObjName=StaticMeshComponent0 Archetype=StaticMeshComponent'Engine.Default__StaticMeshComponent'
      StaticMesh=StaticMesh'GP_Onslaught.Mesh.S_GP_Ons_Power_Node_Base'
      LightEnvironment=BaseLightEnvironment
      CullDistance=7000.000000
      CachedCullDistance=7000.000000
      bUseAsOccluder=False
      CastShadow=False
      bForceDirectLightMap=True
      bCastDynamicShadow=False
      LightingChannels=(BSP=True,Static=True,Dynamic=True)
      CollideActors=False
      Translation=(X=0.000000,Y=0.000000,Z=-15.0)
      Name="StaticMeshComponent0"
      ObjectArchetype=StaticMeshComponent'Engine.Default__StaticMeshComponent'
   End Object
   

   Mesh=StaticMeshComponent0
   bHasSensor=True
   IconHudTexture=None   
   //IconCoords=(U=377.000000,V=438.000000,UL=45.000000,VL=44.000000)
   //IconCoords=(U=537.000000,V=296.000000,UL=46.000000,VL=31.000000)


   GoodSprite=None
   BadSprite=None

   RemoteRole=ROLE_SimulatedProxy
   bStatic=False
   bAlwaysRelevant=True

   //Class=CylinderComponent   
   Begin Object Name=CollisionCylinder ObjName=CollisionCylinder Archetype=CylinderComponent'Engine.Default__CylinderComponent'
      CollisionHeight=6
      CollisionRadius=25
      Name="CollisionCylinder"
      ObjectArchetype=CylinderComponent'Engine.Default__CylinderComponent'
   End Object   
   CylinderComponent=CollisionCylinder
   CollisionComponent=CollisionCylinder
   
   bHasLocationSpeech=False
   DefenderTeamIndex=255
  
   Components(0)=Arrow
   Components(1)=PathRenderer
   Components(2)=BaseLightEnvironment
   Components(3)=StaticMeshComponent0
   Components(4)=CollisionCylinder
   Components(5)=none

   //important to disable this as an objective. we don't use it as an objective yet
   //but may in the future.   
   bIsDisabled = true 
}
